#define BTN D1      // D1
#define LED D2      // D2

bool lastState = HIGH;

void setup() {
  pinMode(BTN, INPUT_PULLUP);
  pinMode(LED, OUTPUT);

  Serial.begin(115200);
  delay(1000);

  Serial.println("Serial Monitor Started!");
  Serial.println("Press the button to toggle LED.");
}

void loop() {
  bool currentState = digitalRead(BTN);

  // Detect button press (HIGH -> LOW)
  if (lastState == HIGH && currentState == LOW) {
    Serial.println("Button Pressed!");

    // Toggle LED
    digitalWrite(LED, !digitalRead(LED));

    if (digitalRead(LED) == HIGH) {
      Serial.println("LED ON");
    } else {
      Serial.println("LED OFF");
    }

    delay(200); // small debounce
  }

  lastState = currentState;
}
